/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.property;

import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import simulator.publisher.VWSIMPublishedSimulation;

public class VWSIMPublishedDataTableModel
extends AbstractTableModel {
    public static final int COLUMN_TYPE = 0;
    public static final int COLUMN_AUTHOR = 1;
    public static final int COLUMN_NAME = 2;
    public static final int COLUMN_DATE = 3;
    private static final int NUMBER_OF_COLUMN = 4;
    private static final DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(3, 3);
    private Vector m_publishedSimulations = new Vector();

    public VWSIMPublishedDataTableModel(VWSIMPublishedSimulation[] publishedSimulations) {
        this.setData(publishedSimulations);
    }

    public void setData(VWSIMPublishedSimulation[] publishedSimulations) {
        this.m_publishedSimulations.clear();
        if (publishedSimulations != null) {
            for (int i = 0; i < publishedSimulations.length; ++i) {
                this.m_publishedSimulations.add(publishedSimulations[i]);
            }
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return VWSIMResource.CurrentVersionAuthor;
            }
            case 2: {
                return VWSIMResource.Name;
            }
            case 3: {
                return VWSIMResource.Date;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_publishedSimulations != null) {
            return this.m_publishedSimulations.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWSIMPublishedSimulation aPublishedData = (VWSIMPublishedSimulation)this.m_publishedSimulations.elementAt(nRowIndex);
            if (aPublishedData == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return new Integer(2);
                }
                case 1: {
                    return aPublishedData.getUserName();
                }
                case 2: {
                    return aPublishedData.getSimulationName();
                }
                case 3: {
                    GregorianCalendar gcl = aPublishedData.getDateTime();
                    return m_dateTimeFormatter.format(gcl.getTime());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void removeRow(int rowId) {
        this.m_publishedSimulations.removeElementAt(rowId);
        this.fireTableRowsDeleted(rowId, rowId);
    }

    public void addRow(Object obj) {
        this.m_publishedSimulations.addElement(obj);
        int rowIndex = this.m_publishedSimulations.size() - 1;
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void clearAll() {
        this.m_publishedSimulations.clear();
        this.fireTableDataChanged();
    }

    public VWSIMPublishedSimulation getRowItemAt(int nRowIndex) {
        if (this.m_publishedSimulations == null || nRowIndex < 0 || nRowIndex > this.m_publishedSimulations.size()) {
            return null;
        }
        if (nRowIndex < this.m_publishedSimulations.size()) {
            return (VWSIMPublishedSimulation)this.m_publishedSimulations.elementAt(nRowIndex);
        }
        return null;
    }

    public void releaseResources() {
        if (this.m_publishedSimulations != null) {
            this.m_publishedSimulations.removeAllElements();
            this.m_publishedSimulations = null;
        }
    }
}

